const fiplab = require('fiplab');
// let fiplab = {arguments: {showAs: 'free'}, exit: function(){ console.log(arguments)}};
const AppStoreUpdater = require('./AppStoreUpdater');
const Utilities = require('./Utilities');
const RankingDatabase = require('./RankingDatabase');

let appID = fiplab.arguments.appID;
let country = fiplab.arguments.region;
let store = fiplab.arguments.storeType;

let updater = new AppStoreUpdater(appID, country, store);
updater.update()
.then(function(data){
  let database = new RankingDatabase(fiplab.db);
  database.add(appID, data);

  let primaryRank = fiplab.arguments.showAs;
  let currentValue = data[primaryRank];

  let lastRanking = database.getLastRanking(appID, primaryRank);

  //Display the user chosen option at the top of the list
  let returnString = Utilities.getOrdinal(currentValue);
  let returnOptions = {};

  if(lastRanking){
    let lastRank = lastRanking[primaryRank];

    //If the rank has changed, then update the display
    if(currentValue != lastRank){
      let isUp;
      let hasLastRank = (typeof(lastRank) == 'number')
      let hasCurrentRank = (typeof(currentValue) == 'number');

      //If we have both ranks and they're not N/A then compare
      if(hasCurrentRank && hasLastRank){
        isUp = (currentValue < lastRank);
      }
      //If we have the last rank and the current rank is N/A
      //Then we've fallen out of the top list so we're not "up"
      else if(hasLastRank && !hasCurrentRank){
        isUp = false;
      }
      //If we don't have a last rank (N/A) and we have one now
      //We most likely came into the top 180 charts, therefore we're up
      else if(hasCurrentRank && !hasLastRank){
        isUp = true;
      }

      let prefix = isUp ? '▲ ' : '▼ ';
      let color = isUp ? '#149839' : '#FD3641';

      returnString = prefix + returnString + ' (' + Utilities.getOrdinal(lastRank) + ')';
      returnOptions = {
        'color': color
      };
    }
  }

  //Show the rest of the items on new lines below the main item
  let keys = Object.keys(data);
  keys.splice(keys.indexOf(primaryRank), 1).sort();

  keys.forEach(function(key){
    let value = data[key];
    returnString += '\n' + Utilities.ucfirst(key) + ': ' + Utilities.getOrdinal(value);
  });

  fiplab.exit(returnString, true, returnOptions);
})
.catch(function(err){
  console.log(err.toString());
  fiplab.exit('App not found or not ranked in the top 180', false);
});